// AcMapFlatOrclApiTestDisplayTextDlg.cpp : implementation file
//
///////////////////////////////////////////////////////////////////////////////
// (C) Copyright 2001 by Autodesk, Inc. 
//
// Permission to use, copy, modify, and distribute this software in
// object code form for any purpose and without fee is hereby granted, 
// provided that the above copyright notice appears in all copies and 
// that both that copyright notice and the limited warranty and
// restricted rights notice below appear in all supporting 
// documentation.
//
// AUTODESK PROVIDES THIS PROGRAM "AS IS" AND WITH ALL FAULTS. 
// AUTODESK SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF
// MERCHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK, INC. 
// DOES NOT WARRANT THAT THE OPERATION OF THE PROGRAM WILL BE
// UNINTERRUPTED OR ERROR FREE.
//
// Use, duplication, or disclosure by the U.S. Government is subject to 
// restrictions set forth in FAR 52.227-19 (Commercial Computer
// Software - Restricted Rights) and DFAR 252.227-7013(c)(1)(ii)
// (Rights in Technical Data and Computer Software), as applicable.
//
// CREATED BY:
//	Hugues Wisniewski, June 2001
//
// DESCRIPTION:
// 	Implementation of class AcMapFlatOrclApiTestDisplayTextDlg

#include "stdafx.h"
#include "AcMapFlatOrclApiTestDisplayTextDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// AcMapFlatOrclApiTestDisplayTextDlg dialog


//******************************************************************************************
AcMapFlatOrclApiTestDisplayTextDlg::AcMapFlatOrclApiTestDisplayTextDlg(
	const std::string& strDlgTitle, //title of the dialog box
	const std::string& strTextTitle, //title of the text field
	const std::string& strText, //value of the text to display
	CWnd* pParent) //parent window, can be NULL
	: CDialog(AcMapFlatOrclApiTestDisplayTextDlg::IDD, pParent),
	m_strDlgTitle(strDlgTitle),
	m_strTextTitle(strTextTitle)
{
	//{{AFX_DATA_INIT(AcMapFlatOrclApiTestDisplayTextDlg)
	m_strText = strText.c_str();
	//}}AFX_DATA_INIT
}


//******************************************************************************************
void AcMapFlatOrclApiTestDisplayTextDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(AcMapFlatOrclApiTestDisplayTextDlg)
	DDX_Control(pDX, IDC_STATIC_TITLE_TEXT, m_staticTitleText);
	DDX_Control(pDX, IDC_EDIT_TEXT, m_editText);
	DDX_Text(pDX, IDC_EDIT_TEXT, m_strText);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(AcMapFlatOrclApiTestDisplayTextDlg, CDialog)
	//{{AFX_MSG_MAP(AcMapFlatOrclApiTestDisplayTextDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// AcMapFlatOrclApiTestDisplayTextDlg message handlers

//******************************************************************************************
BOOL AcMapFlatOrclApiTestDisplayTextDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	m_editText.SetTabStops(200);

	SetWindowText(m_strDlgTitle.c_str());
	m_staticTitleText.SetWindowText(m_strTextTitle.c_str());
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

//******************************************************************************************
void AcMapFlatOrclApiTestDisplayTextDlg::OnOK() 
{
	UpdateData(true);

	if (m_strText.IsEmpty())
	{
		AfxMessageBox("Enter a valid string !");
		return;
	}
	
	CDialog::OnOK();
}

//******************************************************************************************
std::string AcMapFlatOrclApiTestDisplayTextDlg::Text() const
{
	return (const char*)m_strText;
}
